package ru.yandex.chemodan.cache;


import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;

import ru.yandex.bolts.collection.Option;

/**
 * @author eoshch
 */
public class LoadingCacheX<K, V> {
    private final LoadingCache<K, V> cache;

    public LoadingCacheX(LoadingCache<K, V> cache) {
        this.cache = cache;
    }

    public Option<V> get(K key) {
        try {
            return Option.of(cache.getUnchecked(key));
        } catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof DoNotCacheException) {
                cache.invalidate(key);
                //noinspection unchecked
                return ((DoNotCacheException)e.getCause()).value.cast();
            } else {
                throw e;
            }
        }
    }

    public void refresh(K key) {
        cache.refresh(key);
    }

    public void put(K key, V value) {
        cache.put(key, value);
    }

    public void invalidate(Object key) {
        cache.invalidate(key);
    }

    public void invalidateAll() {
        cache.invalidateAll();
    }

    public long size() {
        return cache.size();
    }

    public CacheStats stats() {
        return cache.stats();
    }
}
