package ru.yandex.chemodan.cloud.auth;

import java.util.List;
import java.util.Optional;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.cloud.auth.config.PlatformClientRepository;
import ru.yandex.chemodan.cloud.auth.config.ZkPlatformClientRepository;
import ru.yandex.chemodan.cloud.auth.providers.Authenticator;
import ru.yandex.chemodan.cloud.auth.providers.AuthenticatorByRegistry;
import ru.yandex.chemodan.cloud.auth.providers.PlatformAuthenticationProvider;
import ru.yandex.chemodan.cloud.auth.providers.TokenHeaderAuthenticationProvider;
import ru.yandex.chemodan.cloud.auth.providers.Tvm2AuthenticationProvider;
import ru.yandex.chemodan.util.tvm.TvmClientInfoRegistry;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;
import ru.yandex.inside.passport.tvm2.Tvm2;

@Configuration
public class PlatformSecurityConfiguration {

    @Bean
    PlatformClientRepository platformClientRepository(ZkPath zkPlatformPath, ZkManager zkManager) {
        ZkPlatformClientRepository repository = new ZkPlatformClientRepository(zkPlatformPath);
        zkManager.addClient(repository);
        return repository;
    }

    @Bean
    ScopesFetcher scopesFetcher() {
        return new ScopesFetcher();
    }

    @Bean
    Authenticator authenticator(PlatformClientRepository platformClientRepository, ScopesFetcher scopesFetcher) {
        return new AuthenticatorByRegistry(platformClientRepository, scopesFetcher);
    }

    @Bean
    PlatformAuthenticationProvider platformAuthenticationProvider(Authenticator authenticator) {
        return new TokenHeaderAuthenticationProvider(authenticator);
    }

    @Bean
    PlatformAuthenticationProvider tvmAuthenticationProvider(Authenticator authenticator, Optional<Tvm2> tvm2,
            TvmClientInfoRegistry tvmClientInfoRegistry)
    {
        return new Tvm2AuthenticationProvider(authenticator, tvm2, tvmClientInfoRegistry);
    }

    @Bean
    SecurityPlatformDispatcher securityPlatformInterceptor(List<PlatformAuthenticationProvider> providerList,
            ScopesFetcher scopesFetcher)
    {
        return new SecurityPlatformDispatcher(providerList, scopesFetcher);
    }
}
