package ru.yandex.chemodan.cloud.auth;

import java.util.List;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.misc.test.Assert;
import ru.yandex.misc.web.servlet.mock.MockHttpServletRequest;

public class ScopesFetcherTest {

    private final ScopesFetcher fetcher = new ScopesFetcher();

    @Test
    public void getRequiredScopesWrite() {
        MockHttpServletRequest request = new MockHttpServletRequest("POST", "/personality/profile/morda/desktopnotifications");
        List<String> requiredScopes = fetcher.getRequiredScopes(request, Cf.list("cloud_api.profile:generic.morda.desktopnotifications.write"));
        Assert.notEmpty(requiredScopes);
    }

    @Test
    public void getRequiredScopesRead() {
        MockHttpServletRequest request = new MockHttpServletRequest("GET", "/personality/profile/morda/desktopnotifications");
        List<String> requiredScopes = fetcher.getRequiredScopes(request, Cf.list("cloud_api.profile:generic.morda.desktopnotifications.read"));
        Assert.notEmpty(requiredScopes);
    }

    @Test
    public void getRequiredScopesFail() {
        MockHttpServletRequest request = new MockHttpServletRequest("GET", "/personality/profile/morda/some");
        List<String> requiredScopes = fetcher.getRequiredScopes(request, Cf.list("cloud_api.profile:generic.morda.desktopnotifications.read"));
        Assert.assertEmpty(requiredScopes);
    }

    /**
     * "cloud_api.profile:generic.addresses.write" should allow access to sub paths
     */
    @Test
    public void getRequiredScopesAddresses() {
        MockHttpServletRequest request = new MockHttpServletRequest("POST", "/personality/profile/addresses/morda");
        List<String> requiredScopes = fetcher.getRequiredScopes(request, Cf.list("cloud_api.profile:generic.addresses.write"));
        Assert.notEmpty(requiredScopes);
    }
}
