package ru.yandex.chemodan.cloud.auth.config;

import lombok.Data;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;

@Bendable
@Data
public class PlatformClient {

    @BenderPart(name = "auth_methods", strictName = true)
    private ListF<String> authMethods;
    @BenderPart(name = "name", strictName = true)
    private Option<String> name = Option.empty();
    @BenderPart(name = "oauth_client_id", strictName = true)
    private Option<String> oauthClientId = Option.empty();
    @BenderPart(name = "oauth_client_name", strictName = true)
    private Option<String> oauthClientName = Option.empty();
    @BenderPart(name = "oauth_scopes", strictName = true)
    private ListF<String> oauthScopes;
    @BenderPart(name = "token", strictName = true)
    private Option<String> token = Option.empty();
    @BenderPart(name = "enabled", strictName = true)
    private boolean enabled;
    @BenderPart(name = "tvm_2_0_client_ids", strictName = true)
    private ListF<String> tvm2clientIds;

}
