package ru.yandex.chemodan.cloud.auth.config;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.commune.zk2.ZkPath;

public class ZkPlatformClientRepositoryTest {

    @Test
    public void loadDataByToken() {
        ZkPlatformClientRepository
                repository = new ZkPlatformClientRepository(new ZkPath("/test/test"));
        String data = "[{"
                + "    \"auth_methods\": ["
                + "      \"token\""
                + "    ],"
                + "    \"delete_url\": \"/cloud-api/api-auth/clients/yanews\","
                + "    \"detail_view_url\": \"/cloud-api/api-auth/clients/yanews\","
                + "    \"edit_url\": \"/cloud-api/api-auth/clients/yanews/edit\","
                + "    \"enabled\": true,"
                + "    \"name\": \"yanews\","
                + "    \"oauth_client_id\": \"yanews\","
                + "    \"oauth_client_name\": \"yanews\","
                + "    \"oauth_scopes\": ["
                + "      \"cloud_api.profile:generic.yanews.smi.write\","
                + "      \"cloud_api.profile:generic.yanews.smi.read\","
                + "      \"cloud_api.profile:generic.yanews.rubrics.write\","
                + "      \"cloud_api.profile:generic.yanews.rubrics.read\","
                + "      \"cloud_api.profile:generic.yanews.search.write\","
                + "      \"cloud_api.profile:generic.yanews.search.read\","
                + "      \"cloud_api.profile:generic.yanews.settings.write\","
                + "      \"cloud_api.profile:generic.yanews.settings.read\","
                + "      \"cloud_api.data:app_data\","
                + "      \"cloud_api.data:user_data\""
                + "    ],"
                + "    \"token\": \"405b4bad274341538a625358e75a8c72\""
                + "  }]";
       repository.loadData(data.getBytes());
       Assert.assertNotNull(repository.getClientsByToken());
    }

    @Test
    public void loadDataByTvm2() {
        ZkPlatformClientRepository
                repository = new ZkPlatformClientRepository(new ZkPath("/test/test"));
        String data = "[{"
                + "\"tvm_2_0_client_ids\":[2000900],"
                + "\"name\":\"ya_tv_programs\","
                + "\"oauth_client_name\":\"ya_tv_programs\","
                + "\"enabled\":true,\"allowed_origin_hosts\":[],"
                + "\"ext_tokens\":[],\"token\":\"\","
                + "\"oauth_scopes\":[\"cloud_api.profile:generic.tv.channels.read\",\"cloud_api.profile:generic.tv.channels.write\",\"cloud_api.profile:generic.tv.preferences.read\",\"cloud_api.profile:generic.tv.preferences.write\",\"cloud_api.profile:generic.tv.programs.read\",\"cloud_api.profile:generic.tv.programs.write\",\"cloud_api.profile:generic.tv.regional-schedule.read\",\"cloud_api.profile:generic.tv.regional-schedule.write\",\"cloud_api.profile:generic.tv.session-channels.read\",\"cloud_api.profile:generic.tv.session-channels.write\",\"cloud_api.profile:generic.tv.session-regional-schedule.read\",\"cloud_api.profile:generic.tv.session-regional-schedule.write\",\"cloud_api.profile:generic.tv_test.channels.read\",\"cloud_api.profile:generic.tv_test.channels.write\",\"cloud_api.profile:generic.tv_test.preferences.read\",\"cloud_api.profile:generic.tv_test.preferences.write\",\"cloud_api.profile:generic.tv_test.programs.read\",\"cloud_api.profile:generic.tv_test.programs.write\",\"cloud_api.profile:generic.tv_test.regional-schedule.read\",\"cloud_api.profile:generic.tv_test.regional-schedule.write\",\"cloud_api.profile:generic.tv_test.session-channels.read\",\"cloud_api.profile:generic.tv_test.session-channels.write\",\"cloud_api.profile:generic.tv_test.session-regional-schedule.read\",\"cloud_api.profile:generic.tv_test.session-regional-schedule.write\",\"cloud_api:disk.batch\"],"
                + "\"allowed_network_addresses\":[],"
                + "\"oauth_client_id\":\"ya_tv_programs\","
                + "\"auth_methods\":[\"tvm_2_0\"]"
                + "}]";
        repository.loadData(data.getBytes());
        Assert.assertNotNull(repository.getClientsByTvm2());
    }
}
