package ru.yandex.chemodan.cloud.auth.providers;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.cloud.auth.PlatformAuthentication;
import ru.yandex.chemodan.cloud.auth.PlatformUserDetails;
import ru.yandex.chemodan.cloud.auth.ScopesFetcher;
import ru.yandex.chemodan.cloud.auth.config.PlatformClient;
import ru.yandex.chemodan.cloud.auth.config.PlatformClientRepository;
import ru.yandex.chemodan.util.exception.AccessForbiddenException;
import ru.yandex.commune.a3.action.parameter.WebRequest;

@AllArgsConstructor
public class AuthenticatorByRegistry implements Authenticator {

    private final PlatformClientRepository platformClientRepository;
    private final ScopesFetcher scopesFetcher;

    public Option<PlatformUserDetails> auth(WebRequest webRequest, PlatformAuthentication platformAuthentication) {
        PlatformUserDetails.PlatformUserDetailsBuilder builder = PlatformUserDetails.builder().platformAuthentication(platformAuthentication);
        Option<PlatformClient> platformClients =
                platformClientRepository.findByCredentials(platformAuthentication);

        if (!platformClients.isPresent()) {
            return Option.empty(); //try next
        }
        PlatformClient client = platformClients.get();
        builder.platformClient(client);
        if (!client.isEnabled()) {
            throw new AccessForbiddenException("Client is disabled: " + client);
        }
        scopesFetcher.checkScopes(webRequest, client);
        return Option.of(builder.build());
    }
}
