package ru.yandex.chemodan.cloud.auth.providers;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.cloud.auth.PlatformAuthentication;
import ru.yandex.commune.a3.action.WebRequestMock;
import ru.yandex.commune.a3.action.parameter.WebRequest;

public class TokenHeaderAuthenticationProviderTest {

    @Test
    public void support() {
        Authenticator mock = Mockito.mock(Authenticator.class);
        TokenHeaderAuthenticationProvider provider = new TokenHeaderAuthenticationProvider(mock);
        WebRequest webRequest = new WebRequestMock().header("Authorization", "ClientToken token=a2f313419bd193e79cad;uid=1123132");
        Option<PlatformAuthentication> support = provider.support(webRequest);
        Assert.assertNotNull(support);
        Assert.assertEquals(support.get().getUser(), Option.of("1123132"));
    }

}
