package ru.yandex.chemodan.commentaries;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

/**
 * @author dbrylev
 */
public enum Attitude implements StringEnum {
    LIKE("like"),
    DISLIKE("dislike"),
    ;

    public static final StringEnumResolver<Attitude> R = StringEnumResolver.r(Attitude.class);

    private final String value;

    Attitude(String value) {
        this.value = value;
    }

    @Override
    public String value() {
        return value;
    }
}
