package ru.yandex.chemodan.commentaries;

import ru.yandex.misc.enums.StringEnum;

/**
 * @author dbrylev
 */
public enum CommentsTskvAction implements StringEnum {
    COMMENT_ADD("comment-add"),
    COMMENT_DELETE("comment-delete"),
    COMMENT_RESTORE("comment-restore"),
    LIKE_ADD("comment-like-add"),
    LIKE_DELETE("comment-like-delete"),
    DISLIKE_ADD("comment-dislike-add"),
    DISLIKE_DELETE("comment-dislike-delete"),
    ;

    private final String value;

    CommentsTskvAction(String value) {
        this.value = value;
    }

    @Override
    public String value() {
        return value;
    }

    public static CommentsTskvAction attitudeAdd(Attitude attitude) {
        return attitude == Attitude.LIKE ? LIKE_ADD : DISLIKE_ADD;
    }

    public static CommentsTskvAction attitudeDelete(Attitude attitude) {
        return attitude == Attitude.LIKE ? LIKE_DELETE : DISLIKE_DELETE;
    }
}
