package ru.yandex.chemodan.concurrent;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

import ru.yandex.chemodan.http.YandexCloudRequestIdHolder;

/**
 * @author friendlyevil
 */
public final class ExecutorUtils {

    public static <T> CompletableFuture<T> submitWithYcridForwarding(Supplier<T> supplier, ExecutorService executor) {
        return CompletableFuture.supplyAsync(YandexCloudRequestIdHolder.supplyWithYcrid(supplier), executor);
    }

    public static CompletableFuture<Void> submitWithYcridForwarding(Runnable runnable, ExecutorService executor) {
        return CompletableFuture.runAsync(YandexCloudRequestIdHolder.runWithYcrid(runnable), executor);
    }

    private ExecutorUtils() {
    }
}
