package ru.yandex.chemodan.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import ru.yandex.chemodan.http.YandexCloudRequestIdHolder;
import ru.yandex.misc.test.Assert;

/**
 * @author friendlyevil
 */
public class ExecutorUtilsTest {
    private final static String EMPTY_YCRID = "-";
    private final static String DEFAULT_YCRID = "DEFAULT_YCRID";

    private final ExecutorService executorService = Executors.newFixedThreadPool(1);
    private String taskYcrid;

    @Before
    public void before() {
        YandexCloudRequestIdHolder.set(DEFAULT_YCRID);
        taskYcrid = null;
    }

    @After
    public void after() {
        YandexCloudRequestIdHolder.remove();
    }

    @Test
    public void testYcridForwardingForDefaultSupplier() throws ExecutionException, InterruptedException {
        executorService.submit(this::ycridTask).get();
        Assert.equals(taskYcrid, EMPTY_YCRID);
    }

    @Test
    public void testYcridForwardingForSupplier() throws ExecutionException, InterruptedException {
        ExecutorUtils.submitWithYcridForwarding(this::ycridTask, executorService).get();
        Assert.equals(taskYcrid, DEFAULT_YCRID);
    }

    @Test
    public void testYcridForwardingForDefaultRunnable() throws ExecutionException, InterruptedException {
        executorService.submit(this::runnableYcridTask).get();
        Assert.equals(taskYcrid, EMPTY_YCRID);
    }

    @Test
    public void testYcridForwardingForRunnable() throws ExecutionException, InterruptedException {
        ExecutorUtils.submitWithYcridForwarding(this::runnableYcridTask, executorService).get();
        Assert.equals(taskYcrid, DEFAULT_YCRID);
    }

    private String ycridTask() {
        String ycrid = getYcrid();
        this.taskYcrid = ycrid;
        return ycrid;
    }

    private void runnableYcridTask() {
        this.taskYcrid = getYcrid();
    }

    private String getYcrid() {
        return YandexCloudRequestIdHolder.getO().orElse(EMPTY_YCRID);
    }
}
