package ru.yandex.chemodan.dc.closing;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

import ru.yandex.commune.alive2.AliveAppInfo;
import ru.yandex.commune.alive2.AliveAppRegistrar;

/**
 * @author friendlyevil
 */
// Все изменения стейта в alive apps должны происходить через этот класс
public class AliveAppInfoHolder {
    private static final String DELIMITER = ";";
    private final AliveAppRegistrar aliveAppRegistrar;
    private AliveAppInfo aliveAppInfo;
    private final Set<String> state;

    public AliveAppInfoHolder(AliveAppRegistrar aliveAppRegistrar,
                              AliveAppInfo aliveAppInfo) {
        this.aliveAppRegistrar = aliveAppRegistrar;
        this.aliveAppInfo = aliveAppInfo;
        this.state = parseState(aliveAppInfo.getState());
    }

    public AliveAppInfo get() {
        return aliveAppInfo;
    }

    public synchronized void appendToState(String statePart) {
        state.add(statePart);
        updateState();
    }

    public synchronized void removeFromState(String statePart) {
        state.remove(statePart);
        updateState();
    }

    public boolean stateContains(String statePart) {
        return state.contains(statePart);
    }

    public String getState() {
        return aliveAppInfo.getState();
    }

    private void updateState() {
        String stringState = stateToString(state);
        aliveAppRegistrar.accept(stringState);
        aliveAppInfo = aliveAppInfo.withState(stringState);
    }

    private static String stateToString(Set<String> state) {
        return String.join(DELIMITER, state);
    }

    private static Set<String> parseState(String state) {
        if (state == null || state.isEmpty()) {
            return new LinkedHashSet<>();
        }

        return new LinkedHashSet<>(Arrays.asList(state.split(DELIMITER)));
    }
}
