package ru.yandex.chemodan.dc.closing;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.chemodan.util.ping.PingerChecker;
import ru.yandex.commune.alive2.AliveAppInfo;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author bursy
 */
public class ApplicationClosedStatusHolder implements PingerChecker {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationClosedStatusHolder.class);

    private static final String APP_CLOSED_STATE = "Closed by Zk DC settings";

    private final AliveAppInfoHolder aliveAppInfoHolder;
    private final AliveAppInfo aliveAppInfo;
    private boolean isAppClosed;

    public ApplicationClosedStatusHolder(AliveAppInfoHolder aliveAppInfoHolder, boolean isAppClosed) {
        this.aliveAppInfoHolder = aliveAppInfoHolder;
        this.aliveAppInfo = aliveAppInfoHolder.get();
        this.isAppClosed = isAppClosed;
    }

    public void updateAppStatus(CollectionF<ClosedDataCenterInfo> allClosedDcInfo) {
        if (!aliveAppInfo.getDc().isPresent()) {
            // if no dc is stored, something went terribly wrong at during application start, shouldn't ever happen (tm)
            logger.warn("No DC is stored in alive app info, forced to ignore any setting changes");
            return;
        }

        boolean isClosed = allClosedDcInfo
                .filter(dcInfo -> aliveAppInfo.getDc().get().equals(dcInfo.getDcName()))
                .singleO()
                .map(dcInfo -> dcInfo.isAppClosed(aliveAppInfo.getAppName()))
                // if we don't have stored info about dc being closed, app is not closed
                .getOrElse(false);
        setAppClosedStatus(isClosed);
}

    private void setAppClosedStatus(boolean isClosed) {
        isAppClosed = isClosed;
        if (isClosed) {
            aliveAppInfoHolder.appendToState(APP_CLOSED_STATE);
        } else {
            aliveAppInfoHolder.removeFromState(APP_CLOSED_STATE);
        }
    }

    @Override
    public boolean isActive() {
        return !isAppClosed;
    }
}
