package ru.yandex.chemodan.dc.closing;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.commune.alive2.AliveAppInfo;
import ru.yandex.commune.alive2.AliveAppRegistrar;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;

/**
 * @author bursy
 */
@Configuration
public class ClosedDataCenterContextConfiguration {
    @Bean
    public ClosedDataCenterZkRegistry closedDataCenterZkRegistry(
            @Qualifier("zkAllRoot") ZkPath zkRoot,
            ZkManager zkManager,
            ApplicationClosedStatusHolder applicationClosedStatusHolder)
    {
        ClosedDataCenterZkRegistry registry =
                new ClosedDataCenterZkRegistry(zkRoot.child("closed-dc-info"), applicationClosedStatusHolder);
        zkManager.addClient(registry);
        return registry;
    }

    @Bean
    public ApplicationClosedStatusHolder applicationClosedStatusHolder(
            AliveAppInfoHolder aliveAppInfoHolder,
            @Value("${dc.closing.app.closed-by-default}") Boolean appClosedByDefault)
    {
        return new ApplicationClosedStatusHolder(aliveAppInfoHolder, appClosedByDefault);
    }

    @Bean
    public AliveAppInfoHolder aliveAppInfoHolder(AliveAppRegistrar aliveAppRegistrar,
                                                 AliveAppInfo aliveAppInfo) {
        return new AliveAppInfoHolder(aliveAppRegistrar, aliveAppInfo);
    }
}
