package ru.yandex.chemodan.dc.closing;

import lombok.AllArgsConstructor;
import lombok.Data;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author bursy
 */
@BenderBindAllFields
@AllArgsConstructor
@Data
public class ClosedDataCenterInfo {
    private String dcName;
    private boolean isClosed;
    private boolean isDbsClosed;
    private ListF<String> excludedApps;
    private ListF<String> forceClosedApps;

    public boolean isAppClosed(String appName) {
        return forceClosedApps.containsTs(appName) ||
                (isClosed && !excludedApps.containsTs(appName));
    }

    public void addExcludedApp(String excludedApp) {
        excludedApps = excludedApps.plus1(excludedApp).unique().toList();
    }

    public void removeExcludedApp(String excludedApp) {
        excludedApps = excludedApps.filter(app -> !app.equals(excludedApp));
    }

    public void forceCloseApp(String app) {
        forceClosedApps = forceClosedApps.unique().plus1(app).toList();
    }

    public void openForceClosedApp(String app) {
        forceClosedApps = forceClosedApps.filter(a -> !a.equals(app));
    }

    @Override
    public String toString() {
        return "dcName: " + dcName +
                ", isClosed: " + isClosed +
                ", isDbsClosed: " + isDbsClosed +
                ", excludedApps: " + excludedApps;
    }
}
