package ru.yandex.chemodan.dc.closing;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.ZkRegistry;
import ru.yandex.misc.bender.BenderMapper;

/**
 * @author bursy
 */
public class ClosedDataCenterZkRegistry extends ZkRegistry<String, ClosedDataCenterInfo> {

    public ClosedDataCenterZkRegistry(ZkPath path, ApplicationClosedStatusHolder applicationClosedStatusHolder) {
        super(path, new BenderMapper().createParserSerializer(ClosedDataCenterInfo.class),
                ClosedDataCenterInfo::getDcName, s -> s);
        super.addListener(applicationClosedStatusHolder::updateAppStatus);
    }

    public void init(String dcName) {
        Option<ClosedDataCenterInfo> dcInfoO = getO(dcName);
        if (!dcInfoO.isPresent()) {
            put(createDefaultInfo(dcName));
        }
    }

    public void closeDc(String dcName) {
        setDcClosed(dcName, true);
    }

    public void closeDbsDc(String dcName) {
        setDbsDcClosed(dcName, true);
    }

    public void openDc(String dcName) {
        setDcClosed(dcName, false);
    }

    public void openDbsDc(String dcName) {
        setDbsDcClosed(dcName, false);
    }

    public void closeOneApp(String dcName, String app) {
        ClosedDataCenterInfo dcInfo = getOrDefault(dcName);
        dcInfo.forceCloseApp(app);
        put(dcInfo);
    }

    public void openForceClosedApp(String dcName, String app) {
        ClosedDataCenterInfo dcInfo = getOrDefault(dcName);
        dcInfo.openForceClosedApp(app);
        put(dcInfo);
    }

    public void setExcludedApps(String dcName, ListF<String> excludedApps) {
        ClosedDataCenterInfo dcInfo = getOrDefault(dcName);
        dcInfo.setExcludedApps(excludedApps);
        put(dcInfo);
    }

    public void addExcludedApp(String dcName, String excludedApp) {
        ClosedDataCenterInfo dcInfo = getOrDefault(dcName);
        dcInfo.addExcludedApp(excludedApp);
        put(dcInfo);
    }

    public void removeExcludedApp(String dcName, String excludedApp) {
        ClosedDataCenterInfo dcInfo = getOrDefault(dcName);
        dcInfo.removeExcludedApp(excludedApp);
        put(dcInfo);
    }

    public void clearExcludedApps(String dcName) {
        ClosedDataCenterInfo dcInfo = getOrDefault(dcName);
        dcInfo.setExcludedApps(Cf.list());
        put(dcInfo);
    }

    private void setDcClosed(String dcName, boolean isClosed) {
        ClosedDataCenterInfo dcInfo = getOrDefault(dcName);
        dcInfo.setClosed(isClosed);
        put(dcInfo);
    }

    private void setDbsDcClosed(String dcName, boolean isDbsClosed) {
        ClosedDataCenterInfo dcInfo = getOrDefault(dcName);
        dcInfo.setDbsClosed(isDbsClosed);
        put(dcInfo);
    }

    private ClosedDataCenterInfo getOrDefault(String dcName) {
        return getO(dcName).getOrElse(() -> createDefaultInfo(dcName));
    }

    private ClosedDataCenterInfo createDefaultInfo(String dcName) {
        return new ClosedDataCenterInfo(dcName, false, false, Cf.list(), Cf.list());
    }
}
