package ru.yandex.chemodan.disksearch.indexing;

import java.io.IOException;
import java.net.URI;

import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.io.http.UriBuilder;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class EventIndexerImpl implements EventIndexer {

    private final static Logger logger = LoggerFactory.getLogger(EventIndexerImpl.class);

    private final HttpClient httpClient;

    private final URI indexerUri;

    public EventIndexerImpl(HttpClient httpClient, URI indexerUri) {
        this.httpClient = httpClient;
        this.indexerUri = indexerUri;
    }

    @Override
    public void index(IndexRequest request) {
        logger.info("about to send {} to {}", request, request.uid);
        HttpPost post = createPost(request.uid, request.extraQueryParams, request.toJson());
        HttpResponse response;
        try {
            response = httpClient.execute(post);
        } catch (IOException e) {
            post.releaseConnection();
            throw ExceptionUtils.translate(e);
        }

        try {
            ApacheHttpClientUtils.consume(response.getEntity());
        } catch (RuntimeException e) {
            post.releaseConnection();
        }

        int indexerStatusCode = response.getStatusLine().getStatusCode();
        if (indexerStatusCode != HttpStatus.SC_200_OK) {
            throw new IndexingFailedException("Event is not saved", response.getStatusLine());
        }
    }

    private HttpPost createPost(PassportUid uid, MapF<String, String> queryParams, byte[] body) {
        UriBuilder builder = UriBuilder.cons(indexerUri)
                .addParam("prefix", uid.toString());
        for(Tuple2<String, String> queryParam : queryParams.entries()) {
            builder.addParam(queryParam.get1(), queryParam.get2());
        }
        URI uri = builder.build();

        HttpPost post = new HttpPost(uri);
        post.setHeader("Content-Type", "application/json");
        post.setEntity(new ByteArrayEntity(body));
        return post;
    }
}
