package ru.yandex.chemodan.disksearch.indexing;

import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class EventIndexerStub implements EventIndexer {
    private static final Logger logger = LoggerFactory.getLogger(EventIndexerStub.class);

    public static final DynamicProperty<Integer> eventIndexerStubSleep =
            DynamicProperty.cons("eventIndexerStubSleep", 5);

    @Override
    public void index(IndexRequest request) {
        try {
            Thread.sleep(eventIndexerStubSleep.get());
        } catch (InterruptedException e) {
            logger.warn("Interrupted while sleeping");
        }
    }
}
