package ru.yandex.chemodan.disksearch.indexing;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.bolts.function.Function2B;
import ru.yandex.chemodan.util.tskv.TskvUtils;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class IndexDocument extends DefaultObject {
    public final MapF<String, String> attributes;

    public IndexDocument(MapF<String, String> attributes) {
        this.attributes = attributes;
    }

    IndexDocument(String... keyValues) {
        this(Tuple2List.<String,String>fromPairs((Object[]) keyValues).toMap());
    }

    public boolean matches(IndexDocument patternDocument) {
        return patternDocument.forAllAttributes(this::matches);
    }

    private boolean matches(String key, String valuePattern) {
        return attributes.getO(key)
                .isMatch(v -> v.matches(valuePattern));
    }

    private boolean forAllAttributes(Function2B<String, String> op) {
        return this.attributes.forAllEntries(op);
    }

    static IndexDocument parseTskv(String value) {
        return new IndexDocument(TskvUtils.extractTskv(value));
    }

    public Option<String> getO(String key) {
        return this.attributes.getO(key);
    }
}
