package ru.yandex.chemodan.disksearch.indexing;

import org.apache.commons.lang3.StringUtils;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class IndexDocumentMatcher extends DefaultObject {
    final ListF<IndexDocument> patternDocuments;

    public IndexDocumentMatcher(IndexDocument... patternDocuments) {
        this(Cf.list(patternDocuments));
    }

    public IndexDocumentMatcher(ListF<IndexDocument> patternDocuments) {
        this.patternDocuments = patternDocuments;
    }

    public static IndexDocumentMatcher parse(String value) {
        if (StringUtils.isBlank(value)) {
            return new IndexDocumentMatcher();
        }

        ListF<IndexDocument> documents = Cf.list(value.split(";"))
                .map(s -> s.replace(',', '\t'))
                .map(IndexDocument::parseTskv);
        return new IndexDocumentMatcher(documents);
    }

    public boolean matches(IndexDocument document) {
        for (IndexDocument patternDocument : patternDocuments) {
            if (document.matches(patternDocument)) {
                return true;
            }
        }
        return false;
    }
}
