package ru.yandex.chemodan.disksearch.indexing;

import org.junit.Test;

import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class IndexDocumentMatcherTest {
    private static final IndexDocumentMatcher MATCHER =
            IndexDocumentMatcher.parse("key1=value1,key2=value2;attr2=value2,attr3=value3");

    @Test
    public void testMatch() {
        Assert.assertTrue(MATCHER.matches(new IndexDocument("attr1", "value1", "attr2", "value2", "attr3", "value3")));
    }

    @Test
    public void testDoNotMatch() {
        Assert.assertFalse(MATCHER.matches(new IndexDocument("attr4", "value4", "attr2", "value2", "attr5", "value5")));
    }

    @Test
    public void testEmptyParseIsEmpty() {
        Assert.assertEmpty(IndexDocumentMatcher.parse("").patternDocuments);
    }

    @Test
    public void testParse() {
        Assert.equals(
                new IndexDocumentMatcher(new IndexDocument("event_type", "^comment-.+?$", "entity_type", "^private_resource$")),
                IndexDocumentMatcher.parse("event_type=^comment-.+?$,entity_type=^private_resource$")
        );
    }

    @Test
    public void testMatchRegex() {
        Assert.isFalse(
            new IndexDocumentMatcher(new IndexDocument("event_type", "^comment-.+?$", "entity_type", "^private_resource$"))
                    .matches(new IndexDocument("event_type", "comment-add", "entity_type", "public_resource"))
        );
    }
}
