package ru.yandex.chemodan.disksearch.indexing;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.serialize.BenderJsonSerializer;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class IndexRequest extends DefaultObject {
    private static final BenderJsonSerializer<Json> SERIALIZER = Bender.jsonSerializer(Json.class);

    public final PassportUid uid;

    public final ListF<IndexDocumentWithSource> documents;

    public final ListF<IndexDocumentWithSource> rejectedDocuments;

    public final MapF<String, String> extraQueryParams;

    IndexRequest(PassportUid uid, ListF<IndexDocumentWithSource> documents) {
        this(uid, documents, Cf.list(), Cf.map());
    }

    private IndexRequest(PassportUid uid,
            ListF<IndexDocumentWithSource> documents,
            ListF<IndexDocumentWithSource> rejectedDocuments,
            MapF<String, String> extraQueryParams)
    {
        this.uid = uid;
        this.documents = documents;
        this.rejectedDocuments = rejectedDocuments;
        this.extraQueryParams = extraQueryParams;
    }

    public IndexRequest withQueryParam(String name, String value) {
        return new IndexRequest(
                uid,
                documents,
                rejectedDocuments,
                extraQueryParams.plus1(name, value)
        );
    }

    public IndexDocumentWithSource getDocumentAt(int index) {
        return documents.get(index);
    }

    public byte[] toJson() {
        return SERIALIZER.serializeJson(
                new Json(this.uid, this.documents.map(d -> d.attributes))
        );
    }

    public boolean isNotIndexable() {
        return documents.isEmpty();
    }

    @Bendable
    private static class Json {
        @BenderPart(name="prefix")
        final PassportUid uid;

        @BenderPart(name="docs")
        final ListF<MapF<String, String>> documents;

        Json(PassportUid uid, ListF<MapF<String, String>> documents) {
            this.uid = uid;
            this.documents = documents;
        }
    }

    public IndexRequest rejectDocuments() {
        return rejectDocuments(RejectIndexDocumentMatcherHolder.matcher());
    }

    public IndexRequest rejectDocuments(IndexDocumentMatcher rejectMatcher) {
        Tuple2<ListF<IndexDocumentWithSource>, ListF<IndexDocumentWithSource>> rejectedAndNormal =
                documents.partition(rejectMatcher::matches);
        return new IndexRequest(uid, rejectedAndNormal.get2(), rejectedAndNormal.get1(), extraQueryParams);
    }
}
