package ru.yandex.chemodan.disksearch.indexing;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.BenderParserUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class IndexRequestBuilder<T> {
    private static final Logger logger = LoggerFactory.getLogger(IndexRequestBuilder.class);

    private final BenderMapper mapper;

    private final Function<T, PassportUid> uidF;

    public IndexRequestBuilder(Function<T, PassportUid> uidF) {
        this(new BenderMapper(), uidF);
    }

    public IndexRequestBuilder(BenderMapper mapper, Function<T, PassportUid> uidF) {
        this.mapper = mapper;
        this.uidF = uidF;
    }

    public ListF<IndexRequest> build(CollectionF<T> entities) {
        return build(entities, e -> e.filterMap(this::toDocumentO));
    }

    public ListF<IndexRequest> buildUnsafe(CollectionF<T> entities) {
        return build(entities, e -> e.map(this::toDocument));
    }

    private ListF<IndexRequest> build(CollectionF<T> entities,
            Function<ListF<T>, ListF<IndexDocumentWithSource>> mapperF)
    {
        return entities.groupBy(uidF)
                .mapValues(mapperF)
                .mapEntries(IndexRequest::new)
                .map(IndexRequest::rejectDocuments);
    }

    private Option<IndexDocumentWithSource> toDocumentO(T e) {
        try {
            return Option.of(toDocument(e));
        } catch (RuntimeException ex) {
            logger.warn("Error while serializing entity", ex);
            return Option.empty();
        }
    }

    private IndexDocumentWithSource<T> toDocument(T e) {
        BenderJsonNode json = BenderParserUtils.json(serialize(e));
        MapF<String, String> attributes = json.getFieldNames()
                .toMapMappingToValue(f -> json.getField(f).get().getValueAsString());
        return new IndexDocumentWithSource<>(e, attributes);
    }

    private byte[] serialize(Object e) {
        return mapper.serializeJson(e);
    }
}
