package ru.yandex.chemodan.disksearch.indexing;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class IndexRequestBuilderTest {
    @Test
    public void normalBuild() {
        testBuild(3, new BendableEvent(), new BendableEvent(), new BendableEvent());
    }

    @Test
    public void skipInsteadOfFailOnNonBendableEvents() {
        testBuild(1, new BendableEvent(), new NonBendableEvent());
    }

    @Test
    public void skipInsteadOfFailOnBadlyBendableEvents() {
        testBuild(1, new BendableEvent(), new BadlyBendableEvent());
    }

    private void testBuild(int expectedSize, Object... events) {
        IndexRequestBuilder<Object> builder = new IndexRequestBuilder<>(obj -> new PassportUid(1L));
        ListF<IndexRequest> result = builder.build(Cf.list(events));
        Assert.hasSize(1, result);
        Assert.hasSize(expectedSize, result.first().documents);
    }

    @Bendable
    private static class BendableEvent {

    }

    private static class NonBendableEvent {

    }

    @Bendable
    private static class BadlyBendableEvent {
        @BenderFlatten
        public final String string = "test";
    }
}
