package ru.yandex.chemodan.disksearch.indexing;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class IndexRequestTest {
    @Test
    public void test() {
        String expectedJson =
                "{" +
                    "\"prefix\":123," +
                    "\"docs\":[" +
                        "{\"attr2\":\"value2\",\"attr1\":\"value1\"}," +
                        "{\"attr4\":\"value4\",\"attr3\":\"value3\"}" +
                    "]" +
                "}";
        String actualJson = new String(
                new IndexRequest(PassportUid.cons(123), Cf.list(
                    new IndexDocumentWithSource<>(new Object(), Cf.map("attr1", "value1", "attr2", "value2")),
                    new IndexDocumentWithSource<>(new Object(), Cf.map("attr4", "value4", "attr3", "value3"))
                )).toJson()
        );
        Assert.equals(expectedJson, actualJson);
    }

    @Test
    public void testRejection() {
        assertRejectMatcher(
                new IndexDocumentMatcher(new IndexDocument("event_type", "fs-mkdir")),
                Cf.list(consIndexDocument("event_type", "fs-copy")),
                Cf.list(consIndexDocument("event_type", "fs-mkdir"))
        );
    }

    @Test
    public void doNotRejectWhenParseIsEmpty() {
        assertRejectMatcher(
                IndexDocumentMatcher.parse(""),
                Cf.list(consIndexDocument("event_type", "fs-copy"), consIndexDocument("event_type", "fs-mkdir")),
                Cf.list()
        );
    }

    private void assertRejectMatcher(IndexDocumentMatcher rejectMatcher,
            ListF<IndexDocumentWithSource<Object>> okDocs,
            ListF<IndexDocumentWithSource<Object>> rejectedDocs)
    {
        IndexRequest request = new IndexRequest(PassportUid.cons(1L),
                Cf.<IndexDocumentWithSource>list()
                        .plus(rejectedDocs)
                        .plus(okDocs)
        );
        IndexRequest processedRequest = request.rejectDocuments(rejectMatcher);
        Assert.assertListsEqual(okDocs, processedRequest.documents);
        Assert.assertListsEqual(rejectedDocs, processedRequest.rejectedDocuments);
    }

    private IndexDocumentWithSource<Object> consIndexDocument(String key, String value) {
        return new IndexDocumentWithSource<>(new Object(),
                    Cf.map(key, value));
    }
}
