package ru.yandex.chemodan.disksearch.indexing;

import org.apache.http.StatusLine;

import ru.yandex.bolts.collection.Option;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class IndexingFailedException extends RuntimeException {
    public final Option<StatusLine> status;

    public IndexingFailedException(String message) {
        this(message, Option.empty());
    }

    IndexingFailedException(String message, StatusLine status) {
        this(message + ": status code = " + status.getStatusCode(), Option.of(status));
    }

    private IndexingFailedException(String message, Option<StatusLine> status) {
        super(message);
        this.status = status;
    }
}
