package ru.yandex.chemodan.disksearch.indexing;

import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.commune.dynproperties.DynamicPropertyManager;
import ru.yandex.commune.dynproperties.DynamicPropertyWatcher;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public final class RejectIndexDocumentMatcherHolder extends DefaultObject implements DynamicPropertyWatcher<String> {
    private static final DynamicProperty<String> rejectPattern =
            DynamicProperty.cons("event-loader.reject-pattern", "");

    private static final RejectIndexDocumentMatcherHolder instance = new RejectIndexDocumentMatcherHolder();

    private volatile IndexDocumentMatcher matcher = consMatcherSafe(rejectPattern.get());

    private RejectIndexDocumentMatcherHolder() {}

    public static IndexDocumentMatcher matcher() {
        return instance.matcher;
    }

    @Override
    public void updated(String value) {
        this.matcher = consMatcherSafe(value);
    }

    public static void register(DynamicPropertyManager dynamicPropertyManager) {
        dynamicPropertyManager.addStaticFields(RejectIndexDocumentMatcherHolder.class);
        dynamicPropertyManager.registerAndFireWatcher(rejectPattern, instance);
    }

    private static IndexDocumentMatcher consMatcherSafe(String value) {
        try {
            return IndexDocumentMatcher.parse(value);
        } catch (RuntimeException e) {
            return new IndexDocumentMatcher();
        }
    }
}
