package ru.yandex.chemodan.domenator;

import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.io.http.UriBuilder;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @see <a href="http://domenator-test.yandex.net/docs/swagger#/domains/domain_status_api_domains_status__uid__get"/>
 */
@RequiredArgsConstructor
public class DomenatorClient {
    private static final Logger logger = LoggerFactory.getLogger(DomenatorClient.class);
    private final String host;
    private final RestTemplate restTemplate;

    public Option<DomainInfo> getUserDomainInfo(PassportUid uid) {
        String request = uriBuilder()
                .appendPath("/api/domains/status/")
                .appendPath(uid.toString())
                .addParam("ip", "0.0.0.0")
                .build()
                .toString();
        try {
            ResponseEntity<DomainInfo> response = restTemplate.exchange(
                    request, HttpMethod.GET, HttpEntity.EMPTY, DomainInfo.class);
            return Option.of(response.getBody());
        } catch (RestClientException e) {
            if (hasNotFoundInCause(e)) {
                return Option.empty();
            }
            throw e;
        }
    }

    private boolean hasNotFoundInCause(Exception e) {
        Throwable throwable = e;
        do {
            if ((throwable instanceof HttpClientErrorException) &&
                    ((HttpClientErrorException) throwable).getStatusCode() == HttpStatus.NOT_FOUND) {
                return true;
            }
            throwable = throwable.getCause();

        } while (throwable != null);

        return false;
    }

    private UriBuilder uriBuilder() {
        String hostWithSchema = host;
        if (!hostWithSchema.startsWith("http://") && !hostWithSchema.startsWith("https://")) {
            hostWithSchema = "https://" + hostWithSchema;
        }

        return UriBuilder.cons(hostWithSchema);
    }
}
