package ru.yandex.chemodan.domenator;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.http.HttpClientWithThreadLocalVariable;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.chemodan.web.JacksonContextConfiguration;
import ru.yandex.inside.passport.tvm2.web.Tvm2BaseContextConfiguration;

import static com.google.common.collect.Lists.newArrayList;

@Configuration
@Import({Tvm2BaseContextConfiguration.class,
        JacksonContextConfiguration.class})
public class DomenatorClientContextConfiguration {
    @Bean
    @Qualifier("domenator")
    @OverridableValuePrefix("domenator")
    public HttpClientConfigurator domenatorHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    public DomenatorClient domenatorClient(
            @Value("${domenator.host}") String host, ObjectMapper objectMapper,
            @Qualifier("domenator") HttpClientConfigurator domenatorHttpClientConfigurator) {
        CloseableHttpClient httpClient = domenatorHttpClientConfigurator.createBuilder()
                .multiThreaded()
                .build();
        CloseableHttpClient wrapped = new HttpClientWithThreadLocalVariable(httpClient, "name", "domenator");
        RestTemplate restTemplate = new RestTemplate(new HttpComponentsClientHttpRequestFactory(wrapped));
        restTemplate.setMessageConverters(newArrayList(new MappingJackson2HttpMessageConverter(objectMapper)));

        return new DomenatorClient(host, restTemplate);
    }
}
