package ru.yandex.chemodan.domenator;

import org.apache.http.client.config.RequestConfig;
import org.junit.Rule;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.chemodan.util.test.AbstractTest;
import ru.yandex.chemodan.util.test.HttpRecorderRule;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.test.Assert;

@ContextConfiguration(classes = {DomenatorClientContextConfiguration.class, DomenatorClientTest.Config.class})
public class DomenatorClientTest extends AbstractTest {

    @Autowired
    private DomenatorClient domenatorClient;

    @Rule
    @Autowired
    public final HttpRecorderRule recorderRule = null;

    @Test
    public void testNotFound() {
        Option<DomainInfo> userDomainInfo = domenatorClient.getUserDomainInfo(PassportUid.cons(111));
        Assert.assertNone(userDomainInfo);
    }

    @Test
    public void testDomainExists() {
        Option<DomainInfo> userDomainInfoO = domenatorClient.getUserDomainInfo(PassportUid.cons(4066258824L));
        Assert.assertSome(userDomainInfoO);
        DomainInfo domainsInfo = new DomainInfo(DomainStatus.REGISTERED, "realregtest05.ru", "realregtest05");
        Assert.assertEquals(domainsInfo, userDomainInfoO.get());
    }

    @Configuration
    public static class Config {

        @Bean
        public HttpRecorderRule httpRecorderRule() {
            return HttpRecorderRule.builder().prefix(System.getProperty("user.home") +
                    "/arc/arcadia/disk/support/common/src/test/resources/").build();
        }

        @Bean
        @OverridableValuePrefix("domenator")
        @Qualifier("domenator")
        public HttpClientConfigurator domenatorHttpClientConfigurator(HttpRecorderRule rule) {
            return new HttpClientConfigurator() {
                @Override
                public ApacheHttpClientUtils.Builder createBuilder() {
                    return super.createBuilder().withRequestConfig(RequestConfig.custom().setProxy(rule.getHost()).build())
                            .withRoutePlanner(new HttpRecorderRule.CustomHttpsProxyRoutePlanner())
                            .withRequestRetry();
                }
            };
        }
    }
}
