package ru.yandex.chemodan.graphite.graphite;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.monica.DiskGraphiteMetricsRegistry;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.admin.z.EmptyContentPojo;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.commune.admin.z.ZRedirectException;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.bender.annotation.XmlRootElement;

/**
 * @author tolmalev
 */
@ActionContainer
public class DiskGraphitePusherAdminPage {

    private final DiskGraphiteMetricsRegistry diskGraphiteMetricsRegistry;

    public DiskGraphitePusherAdminPage(DiskGraphiteMetricsRegistry diskGraphiteMetricsRegistry) {
        this.diskGraphiteMetricsRegistry = diskGraphiteMetricsRegistry;
    }


    @ZAction(file = "DiskGraphitePusherAdminPage.xsl", defaultAction = true)
    @Path("/graphite-pusher")
    public PatternsListPojo index() {
        return new PatternsListPojo(diskGraphiteMetricsRegistry.getPatternStrings());
    }

    @ZAction(engineId = "text")
    @Path("/graphite-pusher/add-pattern")
    public EmptyContentPojo addPattern(
            @RequestParam("pattern")
            String patternStr)
    {
        diskGraphiteMetricsRegistry.addPattern(patternStr);
        throw new ZRedirectException("/graphite-pusher");
    }

    @ZAction(engineId = "text")
    @Path("/graphite-pusher/remove-pattern")
    public EmptyContentPojo removePattern(
            @RequestParam("pattern")
            String patternStr)
    {
        diskGraphiteMetricsRegistry.removePattern(patternStr);
        throw new ZRedirectException("/graphite-pusher");
    }

    @Bendable
    @BenderMembersToBind(MembersToBind.ALL_FIELDS)
    @XmlRootElement(name = "content")
    static final class PatternsListPojo {
        public final ListF<String> patterns;

        PatternsListPojo(ListF<String> patterns) {
            this.patterns = patterns;
        }
    }
}
