<?xml version="1.0"?>
<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:z="urn:zscript-functions"
        version="2.0"
        exclude-result-prefixes="#all"
        >

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="content" class="container">
            <h2>Graphite pusher config</h2>
            <br/><br/>

            <xsl:if test="count(patterns) = 0">
                <p class="bg-danger well">
                    No patterns configured
                </p>
            </xsl:if>

            <table class="table table-bordered table-condensed">
                <xsl:for-each select="patterns">
                    <tr>
                        <td>
                            <a class="close" href="/z/graphite-pusher/remove-pattern?pattern={.}">x</a>
                        </td>
                        <td width="100%">
                            <xsl:value-of select="."/>
                        </td>
                    </tr>
                </xsl:for-each>
            </table>

            <form role="form" action="/z/graphite-pusher/add-pattern">
                <div class="form-group">
                    <label for="pattern">Add new pattern</label>
                    <input type="text" class="form-control" name="pattern" id="pattern" placeholder="pattern..."/>
                </div>
                <button type="submit" class="btn btn-primary">Add</button>
            </form>
        </div>
    </xsl:template>

</xsl:stylesheet>
