package ru.yandex.chemodan.graphite.graphite;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.monica.DiskGraphiteMetricsRegistry;
import ru.yandex.commune.monica.pusher.MonicaFieldValuesExtractorRegistry;
import ru.yandex.commune.monica.pusher.graphite.GraphitePusherConfiguration;
import ru.yandex.misc.monica.core.name.FullMetricName;
import ru.yandex.misc.monica.core.name.MetricName;
import ru.yandex.misc.monica.core.name.MetricNamespaceProjection;

/**
 * @author tolmalev
 */
public class DiskGraphitePusherConfiguration extends GraphitePusherConfiguration {

    private final DiskGraphiteMetricsRegistry diskGraphiteMetricsRegistry;

    public DiskGraphitePusherConfiguration(Duration pushPeriod, String graphitePathPrefix,
            ListF<MetricNamespaceProjection> projections,
            MonicaFieldValuesExtractorRegistry fieldValuesExtractorRegistry,
            DiskGraphiteMetricsRegistry diskGraphiteMetricsRegistry)
    {
        super(pushPeriod, graphitePathPrefix, projections, fieldValuesExtractorRegistry);
        this.diskGraphiteMetricsRegistry = diskGraphiteMetricsRegistry;
    }

    @Override
    public boolean isMetricPushEnabled(FullMetricName fullMetricName) {
        return super.isMetricPushEnabled(fullMetricName) && isMetricInConfiguredList(fullMetricName.name);
    }

    public boolean isMetricInConfiguredList(MetricName name) {
        String metricNameStr = name.asList().mkString(".");

        return diskGraphiteMetricsRegistry
                .getPatterns()
                .exists(pattern -> pattern.matches(metricNameStr));
    }
}
