package ru.yandex.chemodan.graphite.graphite;

import org.joda.time.Duration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.monica.DiskGraphiteMetricsRegistry;
import ru.yandex.commune.admin.web.AdminApp;
import ru.yandex.commune.graphite.GraphiteClient;
import ru.yandex.commune.monica.MonicaMasterSnapshotSupplier;
import ru.yandex.commune.monica.pusher.MonicaFieldValuesExtractorRegistry;
import ru.yandex.commune.monica.pusher.graphite.GraphitePusherConfiguration;
import ru.yandex.commune.monica.pusher.graphite.MonicaGraphitePusher;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.ip.HostPort;
import ru.yandex.misc.monica.MonicaConfiguration;
import ru.yandex.misc.monica.core.name.MetricNamespaceProjection;
import ru.yandex.misc.monica.core.name.NameDimension;

/**
 * @author Lev Tolmachev
 */
@Configuration
public class DiskGraphitePusherContextConfiguration {

    @Bean
    public GraphiteClient graphiteClient() {
        //XXX: waiting for support of ipv6 in graphite
        return new GraphiteClient(Cf.list(new HostPort("127.0.0.1", 42000)));
    }

    @Bean
    public DiskGraphitePusherAdminPage diskGraphitePusherAdminPage(DiskGraphiteMetricsRegistry registry) {
        return new DiskGraphitePusherAdminPage(registry);
    }

    @Bean
    public MonicaGraphitePusher monicaGraphitePusher(
            MonicaMasterSnapshotSupplier monicaLocalSnapshotSupplier,
            MonicaConfiguration monicaConfiguration,
            GraphiteClient graphiteClient,
            DiskGraphiteMetricsRegistry diskGraphiteMetricsRegistry,
            EnvironmentType environmentType)
    {
        String service = monicaConfiguration.localNamespace().value(NameDimension.SERVICE_NAME);

        DiskGraphitePusherConfiguration configuration = new DiskGraphitePusherConfiguration(
                Duration.standardSeconds(30),
                GraphitePusherConfiguration.consGraphitePathPrefix(service),
                projections(environmentType),
                MonicaFieldValuesExtractorRegistry.defaultRegistry(), diskGraphiteMetricsRegistry);

        MonicaGraphitePusher pusher = new MonicaGraphitePusher(configuration, graphiteClient);

        monicaLocalSnapshotSupplier.registerConsumer(pusher);

        return pusher;
    }

    @Bean
    public Void init(AdminApp adminApp, DiskGraphitePusherAdminPage diskGraphitePusherAdminPage) {
        adminApp.registerAdminPage("Graphite pusher", diskGraphitePusherAdminPage);
        return null;
    }

    public static ListF<MetricNamespaceProjection> projections(EnvironmentType environmentType) {
        return Cf.list(
                new MetricNamespaceProjection(
                        NameDimension.ENVIRONMENT,
                        NameDimension.SERVICE_NAME
                )
        );
    }

}
