package ru.yandex.chemodan.http;

import javax.servlet.http.HttpServletRequest;

import org.eclipse.jetty.server.Server;

import ru.yandex.bolts.function.Function;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

/**
 * @author nshmakov
 */
public class DiskJetty extends SingleWarJetty {
    private final Function<HttpServletRequest, String> prefixResolver;

    public DiskJetty(String ycridPrefix) {
        this.prefixResolver = (request) -> ycridPrefix;
    }

    public DiskJetty(Function<HttpServletRequest, String> prefixResolver) {
        this.prefixResolver = prefixResolver;
    }

    @Override
    protected void addPushRequestIdHandler(Server server) {
        YandexCloudRequestIdHandler handler = new YandexCloudRequestIdHandler(prefixResolver);
        handler.setHandler(server.getHandler());
        server.setHandler(handler);
    }
}
