package ru.yandex.chemodan.http;

import java.io.IOException;

import lombok.RequiredArgsConstructor;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

import ru.yandex.chemodan.log.CloseableMdc;

@RequiredArgsConstructor
public class HttpClientWithThreadLocalVariable extends CloseableHttpClient {
    private final CloseableHttpClient client;
    private final String key;
    private final String value;

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context)
            throws IOException
    {
        try (final CloseableMdc.Instance ignored = CloseableMdc.put(key, value)) {
            return client.execute(target, request, context);
        }
    }

    @Override
    public void close() throws IOException {
        client.close();
    }

    @Override
    public HttpParams getParams() {
        return client.getParams();
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return client.getConnectionManager();
    }
}
