package ru.yandex.chemodan.http;

import javax.servlet.http.HttpServletRequest;

import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class JettyHandlerUtil {
    private static final Logger logger = LoggerFactory.getLogger(YandexCloudRequestIdHandler.class);

    /**
     * For logging exceptions at handlers, which add ycrid and rid to ThreadLocal context. Such a decision was made
     * because it is last chance to preserve exception alongside ycrid and rid.
     *
     * Stack trace removal is needed because we do not want to log it upper in call chain.
     *
     * @link https://st.yandex-team.ru/CHEMODAN-41515#1522774374000
     */
    public static void logExceptionAndRemoveStackTrace(HttpServletRequest request, Exception ex) {
        logger.error("Got error for {} {}: {}", request.getMethod(), request.getRequestURI(),
                ExceptionUtils.getStackTrace(ex)
        );
        ExceptionUtils.removeStackTraceRecursive(ex);
    }
}
