package ru.yandex.chemodan.http;

import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.commune.a3.action.intercept.ActionInvocationInterceptor;
import ru.yandex.commune.a3.action.intercept.InvocationInterceptorOrders;
import ru.yandex.commune.a3.action.invoke.ActionInvocation;
import ru.yandex.misc.io.IoFunction0;

/**
 * @author yashunsky
 */
public class KeepUaasHeadersInterceptor implements ActionInvocationInterceptor {

    private final SetF<String> significantHeaders = Cf.set(CommonHeaders.X_FORWARDED_FOR_Y.toLowerCase());

    @Override
    public Object intercept(ActionInvocation invocation) throws Exception {
        ListF<Header> headers = invocation.getWebRequest().getHttpServletRequest().getHeaders()
                .filterBy1(header -> significantHeaders.containsTs(header.toLowerCase())).map(BasicHeader::new);
        return UaasHeadersHolder.withHeaders(headers, (IoFunction0<Object>)(invocation::invoke));
    }

    @Override
    public int getOrder() {
        return InvocationInterceptorOrders.COMMON_ATTRIBUTES_INTERCEPTOR_ORDER;
    }

}
