package ru.yandex.chemodan.http;

import javax.servlet.http.HttpServletRequest;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.log.TskvNdcUtil;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.log.mlf.ndc.Ndc;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class RequestNdcUtil {
    private static final String NDC_ATTRIBUTE_NAME = "request-ndc";

    public static boolean ndcIsNotStored(HttpServletRequest request) {
        return request.getAttribute(NDC_ATTRIBUTE_NAME) == null;
    }

    public static Option<MapF<String, String>> getNdcO(HttpServletRequest request) {
        return getNdcStrO(request)
                .map(str -> "#" + str)
                .map(TskvNdcUtil::parseNdc);
    }

    public static Option<String> getNdcStrO(HttpServletRequest request) {
        return Option.ofNullable(request.getAttribute(NDC_ATTRIBUTE_NAME))
                .cast();
    }

    public static void storeCurrentNdc(HttpServletRequest request) {
        request.setAttribute(NDC_ATTRIBUTE_NAME, StringUtils.substringAfter(Ndc.get(), "#"));
    }
}
