package ru.yandex.chemodan.http;

import org.apache.http.Header;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function0;

/**
 * @author yashunsky
 */
public class UaasHeadersHolder {
    private static final ThreadLocal<ListF<Header>> holder = new ThreadLocal<>();

    public static <T> T withHeaders(ListF<Header> headers, Function0<T> fn) {
        holder.set(headers);
        try {
            return fn.apply();
        } finally {
            holder.remove();
        }
    }

    public static ListF<Header> get() {
        return Option.ofNullable(holder.get()).flatten();
    }
}
