package ru.yandex.chemodan.http;

import java.util.function.Supplier;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.log.TskvNdcUtil;
import ru.yandex.misc.ThreadLocalX;
import ru.yandex.misc.log.mlf.ndc.Ndc;
import ru.yandex.misc.log.reqid.RequestIdStack;
import ru.yandex.misc.support.tl.ThreadLocalHandle;

/**
 * @author dbrylev
 */
public class YandexCloudRequestIdHolder {
    private static final ThreadLocalX<String> ycrid = new ThreadLocalX<>();

    public static Option<String> getO() {
        return ycrid.getO();
    }

    public static void set(String requestId) {
        ycrid.set(requestId);
    }

    public static void remove() {
        ycrid.remove();
    }

    public static ThreadLocalHandle setAndPushToNdc(String ycrid) {
        YandexCloudRequestIdHolder.set(ycrid);

        Ndc.Handle h = TskvNdcUtil.pushToNdc("ycrid", ycrid);

        return new ThreadLocalHandle() {
            public void pop() {
                h.popSafely();
                remove();
            }
        };
    }

    public static <T> Supplier<T> supplyWithYcrid(Supplier<T> supplier) {
        Option<String> rid = RequestIdStack.current();
        Option<String> ycrid = YandexCloudRequestIdHolder.getO();

        return () -> {
            Option<RequestIdStack.Handle> ridHandle = rid.map(RequestIdStack::pushReplace);
            Option<ThreadLocalHandle> ycridHandle = ycrid.map(YandexCloudRequestIdHolder::setAndPushToNdc);

            try {
                return supplier.get();
            } finally {
                ridHandle.ifPresent(ThreadLocalHandle::popSafely);
                ycridHandle.ifPresent(ThreadLocalHandle::popSafely);
            }
        };
    }

    public static Runnable runWithYcrid(Runnable runnable) {
        Supplier<Object> supplier = supplyWithYcrid(() -> {
            runnable.run();
            return null;
        });

        return supplier::get;
    }
}
