package ru.yandex.chemodan.http.proxy;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author vpronto
 *
 * see X-Accel-Redirect
 */
public class AccelProxy implements ProxyService {

    public static final String ACCEL_REDIRECT = "X-Accel-Redirect";

    @Override
    public Option<String> service(HttpProxyContext proxyContext) {
        proxyContext.getResponse().setStatus(HttpStatus.SC_204_NO_CONTENT);
        String path = generatePath(proxyContext);
        proxyContext.getResponse().setHeader(ACCEL_REDIRECT, path);
        return Option.of(path);
    }

    private String generatePath(HttpProxyContext proxyContext) {
        return "/proxy_" + proxyContext.getRequest().getMethod().toLowerCase() + "/" + proxyContext.getHost();
    }
}
