package ru.yandex.chemodan.http.proxy;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import lombok.Value;
import org.apache.http.HttpHost;
import org.springframework.util.Assert;

import ru.yandex.bolts.collection.Option;

/**
 * @author vpronto
 * Class which contains some data for proxied request
 */
@Value
public final class HttpProxyContext {

    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final String host;

    public HttpProxyContext(HttpServletRequest request, HttpServletResponse response, String host) {
        this.request = request;
        Assert.notNull(request, "request is null");
        this.response = response;
        Assert.notNull(response, "response is null");
        Assert.notNull(host, "host is null");
        this.host = host;
    }

    public HttpHost getTargetHost() {
        return new HttpHost(host,
                request.getLocalPort(),
                Option.ofNullable(request.getScheme()).getOrElse("http"));
    }
}
