package ru.yandex.chemodan.http.proxy;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.chemodan.dc.closing.AliveAppInfoHolder;
import ru.yandex.chemodan.util.ping.CoolPingServlet;
import ru.yandex.misc.worker.spring.DelayingWorkerServiceBeanSupport;

/**
 * @author friendlyevil
 */
public class ProxyPingLockWorkerService extends DelayingWorkerServiceBeanSupport {
    private final AliveAppInfoHolder aliveAppInfoHolder;
    private final CoolPingServlet coolPingServlet;
    private final String lockState;


    public ProxyPingLockWorkerService(AliveAppInfoHolder aliveAppInfoHolder,
                                      CoolPingServlet coolPingServlet,
                                      String lockState) {
        this.aliveAppInfoHolder = aliveAppInfoHolder;
        this.coolPingServlet = coolPingServlet;
        this.lockState = lockState;
    }

    @Override
    @Value("${http.proxy.maintenance.lock.check.delay}")
    public void setDelay(Duration delay) {
        super.setDelay(delay);
    }

    @Override
    protected void execute() throws Exception {
        checkMaintenanceLockAndUpdateState();
    }

    private void checkMaintenanceLockAndUpdateState() {
        if (!coolPingServlet.isAvailable() && !aliveAppInfoHolder.stateContains(lockState)) {
            aliveAppInfoHolder.appendToState(lockState);
        } else if (coolPingServlet.isAvailable() && aliveAppInfoHolder.stateContains(lockState)) {
            aliveAppInfoHolder.removeFromState(lockState);
        }
    }
}
