package ru.yandex.chemodan.log;

import java.io.BufferedReader;
import java.io.IOException;
import java.security.Principal;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;

import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;

import org.eclipse.jetty.server.Request;

import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author vpronto
 */
public class BatchServletRequest extends Request {

    private final HttpServletRequestX outerRequest;
    private final HttpServletRequest subRequest;
    private final long timeStamp;

    public BatchServletRequest(HttpServletRequestX outerRequest, HttpServletRequest subRequest, long timeStamp) {
        super(null, null);
        this.outerRequest = outerRequest;
        this.subRequest = subRequest;
        this.timeStamp = timeStamp;
    }

    public long getTimeStamp() {
        return timeStamp;
    }

    @Override
    public String getMethod() {
        return subRequest.getMethod();
    }

    @Override
    public String getParameter(String name) {
        return subRequest.getParameter(name);
    }

    @Override
    public int getContentLength() {
        return subRequest.getContentLength();
    }

    @Override
    public String getProtocol() {
        return subRequest.getProtocol();
    }

    @Override
    public long getDateHeader(String name) {
        return subRequest.getDateHeader(name);
    }

    @Override
    public long getContentLengthLong() {
        return subRequest.getContentLengthLong();
    }

    @Override
    public Collection<Part> getParts() throws IOException, ServletException {
        return subRequest.getParts();
    }

    @Override
    public Part getPart(String name) throws IOException, ServletException {
        return subRequest.getPart(name);
    }

    @Override
    public String getHeader(String name) {
        return outerRequest.getHeader(name);
    }

    @Override
    public Enumeration<String> getHeaderNames() {
        return outerRequest.getHeaderNames();
    }

    @Override
    public Enumeration<String> getHeaders(String name) {
        return outerRequest.getHeaders(name);
    }

    @Override
    public int getIntHeader(String name) {
        return subRequest.getIntHeader(name);
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return subRequest.getParameterMap();
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return subRequest.getParameterNames();
    }

    @Override
    public String[] getParameterValues(String name) {
        return subRequest.getParameterValues(name);
    }

    @Override
    public String getPathTranslated() {
        return subRequest.getPathTranslated();
    }

    @Override
    public String getPathInfo() {
        return subRequest.getPathInfo();
    }

    @Override
    public String getScheme() {
        return subRequest.getScheme();
    }

    @Override
    public String getServletPath() {
        return subRequest.getServletPath();
    }

    @Override
    public Locale getLocale() {
        return outerRequest.getLocale();
    }

    public static Request getBaseRequest(ServletRequest request) {
        return Request.getBaseRequest(request);
    }

    @Override
    public Object getAttribute(String name) {
        return outerRequest.getAttribute(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return outerRequest.getAttributeNames();
    }

    @Override
    public String getAuthType() {
        return outerRequest.getAuthType();
    }

    @Override
    public String getCharacterEncoding() {
        return outerRequest.getCharacterEncoding();
    }

    @Override
    public String getContentType() {
        return outerRequest.getContentType();
    }

    @Override
    public String getContextPath() {
        return outerRequest.getContextPath();
    }

    @Override
    public Cookie[] getCookies() {
        return outerRequest.getCookies();
    }

    @Override
    public DispatcherType getDispatcherType() {
        return outerRequest.getDispatcherType();
    }

    @Override
    public Enumeration<Locale> getLocales() {
        return outerRequest.getLocales();
    }

    @Override
    public String getLocalAddr() {
        return outerRequest.getLocalAddr();
    }

    @Override
    public String getLocalName() {
        return outerRequest.getLocalName();
    }

    @Override
    public int getLocalPort() {
        return outerRequest.getLocalPort();
    }

    @Override
    public String getQueryString() {
        return subRequest.getQueryString();
    }

    @Override
    public BufferedReader getReader() throws IOException {
        return outerRequest.getReader();
    }

    @Override
    public String getRealPath(String path) {
        return subRequest.getRealPath(path);
    }

    @Override
    public String getRemoteAddr() {
        return outerRequest.getRemoteAddr();
    }

    @Override
    public String getRemoteHost() {
        return outerRequest.getRemoteHost();
    }

    @Override
    public int getRemotePort() {
        return outerRequest.getRemotePort();
    }

    @Override
    public String getRemoteUser() {
        return outerRequest.getRemoteUser();
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        return outerRequest.getRequestDispatcher(path);
    }

    @Override
    public String getRequestedSessionId() {
        return outerRequest.getRequestedSessionId();
    }

    @Override
    public String getRequestURI() {
        return subRequest.getRequestURI();
    }

    @Override
    public StringBuffer getRequestURL() {
        return outerRequest.getRequestURL();
    }

    @Override
    public String getServerName() {
        return outerRequest.getServerName();
    }

    @Override
    public int getServerPort() {
        return outerRequest.getServerPort();
    }

    @Override
    public ServletContext getServletContext() {
        return outerRequest.getServletContext();
    }


    @Override
    public String changeSessionId() {
        return outerRequest.changeSessionId();
    }

    @Override
    public HttpSession getSession() {
        return outerRequest.getSession();
    }

    @Override
    public HttpSession getSession(boolean create) {
        return outerRequest.getSession(create);
    }


    @Override
    public Principal getUserPrincipal() {
        return outerRequest.getUserPrincipal();
    }


    @Override
    public boolean isAsyncStarted() {
        return outerRequest.isAsyncStarted();
    }

    @Override
    public boolean isAsyncSupported() {
        return outerRequest.isAsyncSupported();
    }

    @Override
    public boolean isRequestedSessionIdFromCookie() {
        return outerRequest.isRequestedSessionIdFromCookie();
    }

    @Override
    public boolean isRequestedSessionIdFromUrl() {
        return outerRequest.isRequestedSessionIdFromUrl();
    }

    @Override
    public boolean isRequestedSessionIdFromURL() {
        return outerRequest.isRequestedSessionIdFromURL();
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        return outerRequest.isRequestedSessionIdValid();
    }

    @Override
    public boolean isSecure() {
        return outerRequest.isSecure();
    }

    @Override
    public boolean isUserInRole(String role) {
        return outerRequest.isUserInRole(role);
    }

}
