package ru.yandex.chemodan.log;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Locale;

import javax.servlet.http.HttpServletResponse;

import org.eclipse.jetty.server.Response;

/**
 * @author vpronto
 */
public class BatchServletResponse extends Response {

    private final HttpServletResponse response;
    private final long contentCount;

    public BatchServletResponse(HttpServletResponse response, long contentCount) {
        super(null, null);
        this.response = response;
        this.contentCount = contentCount;
    }

    @Override
    public boolean containsHeader(String name) {
        return response.containsHeader(name);
    }

    @Override
    public Collection<String> getHeaderNames() {
        return response.getHeaderNames();
    }

    @Override
    public String getHeader(String name) {
        return response.getHeader(name);
    }

    @Override
    public Collection<String> getHeaders(String name) {
        return response.getHeaders(name);
    }

    @Override
    public String getContentType() {
        return response.getContentType();
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        return response.getWriter();
    }

    @Override
    public long getContentLength() {
        return contentCount;
    }

    @Override
    public int getStatus() {
        return response.getStatus();
    }

    @Override
    public String encodeURL(String url) {
        return response.encodeURL(url);
    }

    @Override
    public String encodeRedirectURL(String url) {
        return response.encodeRedirectURL(url);
    }

    @Override
    public String getCharacterEncoding() {
        return response.getCharacterEncoding();
    }

    @Override
    public long getLongContentLength() {
        return contentCount;
    }


    @Override
    public Locale getLocale() {
        return response.getLocale();
    }

    @Override
    public long getContentCount() {
        return contentCount;
    }

}
