package ru.yandex.chemodan.log;

import org.apache.logging.log4j.CloseableThreadContext;

/**
 * @author eoshch
 */
public class CloseableMdc {
    public static class Instance implements AutoCloseable {
        private CloseableThreadContext.Instance instance;

        private Instance(CloseableThreadContext.Instance instance) {
            this.instance = instance;
        }

        public Instance put(final String key, final String value) {
            this.instance.put(key, value);
            return this;
        }

        @Override
        public void close() {
            this.instance.close();
        }
    }

    public static CloseableMdc.Instance put(final String key, final String value) {
        return new CloseableMdc.Instance(CloseableThreadContext.put(key, value));
    }
}
