package ru.yandex.chemodan.log;

import org.junit.Test;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class DiskLog4jRequestLogTest {
    @Test
    public void filterAuthorization() {
        Assert.isFalse(
                DiskLog4jRequestLog.makeHeadersLogLine(
                        Tuple2List.fromPairs("a", "b", "Authorization", "private_token", "c", "d")
                ).contains("private_token")
        );

        Assert.isFalse(
                DiskLog4jRequestLog.makeHeadersLogLine(
                        Tuple2List.fromPairs("Authorization", "private_token", "c", "d")
                ).contains("private_token")
        );

        Assert.isFalse(
                DiskLog4jRequestLog.makeHeadersLogLine(
                        Tuple2List.fromPairs("a", "b", "Authorization", "private_token")
                ).contains("private_token")
        );

        Assert.isFalse(
                DiskLog4jRequestLog.makeHeadersLogLine(
                        Tuple2List.fromPairs("Authorization", "private_token")
                ).contains("private_token")
        );

        Assert.isTrue(
                DiskLog4jRequestLog.makeHeadersLogLine(
                        Tuple2List.fromPairs("Authorization", "private_token")
                ).contains("UNKNOWN[13]")
        );

        Assert.isTrue(
                DiskLog4jRequestLog.makeHeadersLogLine(
                        Tuple2List.fromPairs("Authorization", "")
                ).contains("UNKNOWN[0]")
        );

        Assert.isTrue(
                DiskLog4jRequestLog.makeHeadersLogLine(
                        Tuple2List.fromPairs("Authorization", " oAuTh private_token")
                ).contains("OAUTH[20]")
        );
    }

    @Test
    public void simpleEncode() {
        Assert.equals("{ \"a\": \"b\" }",
                DiskLog4jRequestLog.makeHeadersLogLine(
                        Tuple2List.fromPairs("a", "b")
                )
        );

        Assert.equals("{ \"a\": \"b\", \"c\": \"d\" }",
                DiskLog4jRequestLog.makeHeadersLogLine(
                        Tuple2List.fromPairs("a", "b", "c", "d")
                )
        );
    }

    @Test
    public void emptyValue() {
        Assert.equals("{ \"a\": \"\", \"c\": \"d\" }",
                DiskLog4jRequestLog.makeHeadersLogLine(
                        Tuple2List.fromPairs("a", "", "c", "d")
                )
        );
    }

    @Test
    public void escape() {
        Assert.equals("{ \"a\": \"\\\"b\" }",
                DiskLog4jRequestLog.makeHeadersLogLine(
                        Tuple2List.fromPairs("a", "\"b")
                )
        );
    }

}
