package ru.yandex.chemodan.log;

import org.eclipse.jetty.util.log.AbstractLogger;

import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * mlf support for jetty logging
 * @author vpronto
 */
public class Jetty2MlfBridge extends AbstractLogger
{
    private Logger logger;
    private String name;

    public Jetty2MlfBridge(String name)
    {
        this.name = name;
        logger = LoggerFactory.getLogger(name);
    }

    @Override
    protected org.eclipse.jetty.util.log.Logger newLogger(String fullname) {
        return new Jetty2MlfBridge(fullname);
    }

    public String getName() {
        return name;
    }

    public void warn(String msg, Object... args) {
        logger.warn(msg, args);
    }

    public void warn(Throwable thrown) {
        logger.warn(thrown);
    }

    public void warn(String msg, Throwable thrown) {
        logger.warn(msg, thrown);
    }

    public void info(String msg, Object... args) {
        logger.info(msg, args);
    }

    public void info(Throwable thrown) {
        logger.info(thrown);
    }

    public void info(String msg, Throwable thrown) {
        logger.info(msg, thrown);
    }

    public boolean isDebugEnabled() {
        return false;
    }

    public void setDebugEnabled(boolean enabled) { }

    public void debug(String msg, Object... args) { }

    public void debug(Throwable thrown) { }

    public void debug(String msg, Throwable thrown) { }

    public void ignore(Throwable ignored) { }
}
