package ru.yandex.chemodan.log;

import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.ndc.Ndc;
import ru.yandex.misc.test.Assert;

import static ru.yandex.chemodan.log.LoggerProxies.countPlaceholders;

/**
 * @author dbrylev
 */
public class LoggerProxiesTest {

    @Test
    public void withNdc() {
        Logger mock = Mockito.mock(Logger.class, (Answer) m -> { Assert.equals(Ndc.get(), "#NDC"); return null; });
        Logger logger = LoggerProxies.withNdc(mock, "NDC");

        logSomeMessages(logger);
    }

    @Test
    public void noStackTrace() {
        logSomeMessages(LoggerProxies.noStackTrace(LoggerProxies.class));
    }

    private static void logSomeMessages(Logger logger) {
        logger.debug(1);
        logger.debug("debug");
        logger.info("info {}", "info");
        logger.info(new Exception("exception"));
        logger.warn(1, new Exception("exception"));
        logger.warn("warn", new Exception("exception"));
        logger.error("{}", "error", new Exception("exception"));
        logger.error("{}: {}", "error", new Exception("exception"));
    }

    @Test
    public void placeholdersCount() {
        Assert.equals(0, countPlaceholders(null));
        Assert.equals(1, countPlaceholders("{}"));
        Assert.equals(0, countPlaceholders("\\{}"));
        Assert.equals(1, countPlaceholders("\\\\{}"));
        Assert.equals(2, countPlaceholders("x{}x{}x"));
        Assert.equals(2, countPlaceholders("{}\\\\{}"));
        Assert.equals(1, countPlaceholders("\\{}\\\\{}"));
        Assert.equals(4, countPlaceholders("{}x{}x{}x{}"));
        Assert.equals(2, countPlaceholders("\\\\{}\\\\{}"));
    }
}
